<?php
/*
Template Name: Front Page
.
Take a look at the functions.php for this theme to see how the random content is included.
.
*/
?>
<?php get_header() ?>

	<div id="container" class="feature">
		<div id="content">		
		  <div id="sub-feature">

            <div id="front-block-1" class="front-block block">  
              <h3>Who's Behind <?php bloginfo('name') ?>?</h3>
              <?php
                    $user_info = get_userdata(1);
                    $gravatar_email = $user_info->user_email;
                    echo get_avatar($gravatar_email, '84');
              ?>
              <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed eu velit. Maecenas eu orci ac orci vulputate ullamcorper. Nullam tempor velit non nisl. Etiam neque. Maecenas tristique. Fusce a tellus.</p>
              <p>Maecenas fringilla mi nec diam. Donec iaculis lacus sed dolor. Ut varius quam varius nunc. Nunc ut metus. Quisque massa lacus, pulvinar eget, tempor in, feugiat nec, diam. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vivamus et eros. Donec.</p>
              <p><a href="<?php echo get_option('home') ?>/about/" rel="nofollow">Read more at my about page</a></p>
            </div><!-- #front-block-1 .front-block .block-->
            
            <div id="front-block-2" class="front-block block">  
              <h3>Recent Items From The <?php bloginfo('name') ?> Blog <a href="<?php bloginfo('rss2_url') ?>" title="<?php echo wp_specialchars(get_bloginfo('name'), 1) ?> <?php _e('Posts RSS feed', 'thematic'); ?>" rel="alternate nofollow" type="application/rss+xml"><img src="<?php echo dirname( get_bloginfo('stylesheet_url') ) ?>/images/feed-icon-14x14.gif" alt="RSS"/></a></h3>
              <ul id="recent-items">
              <?php
                  $recentPosts = new WP_Query();
                  $recentPosts->query('showposts=5');
              ?>
              <?php while ($recentPosts->have_posts()) : $recentPosts->the_post(); ?>
                  <li><a href="<?php the_permalink() ?>" rel="bookmark"><?php the_title(); ?></a></li>
              <?php endwhile; ?>
                    <li class="more-items"><a href="<?php echo get_option('home') ?>/blog/page/2/">More recent items <span>»</span></a></li>
              </ul>
            </div><!-- #front-block-2 .front-block .block-->
          
          </div><!-- #sub-feature -->         
		</div><!-- #content -->
	</div><!-- #container .feature -->

<?php get_footer() ?>