<?php

// Add a search form to the header
function childtheme_searchform() {
    get_search_form();
}
add_action('thematic_header','childtheme_searchform',7);

// Customize the search form
function childtheme_search_form($form) {
    $form = '<form method="get" id="searchform" action="' . get_option('home') . '/" >
            <label class="hidden" for="s">' . __('Search:') . '</label>
            <div>';
    if (is_search()) {
        $form .='<input type="text" value="' . attribute_escape(apply_filters('the_search_query', get_search_query())) . '" name="s" id="s" />';
    } else {
        $form .='<input type="text" value="To search, type and hit enter" name="s" id="s"  onfocus="if(this.value==this.defaultValue)this.value=\'\';" onblur="if(this.value==\'\')this.value=this.defaultValue;"/>';
    }
    $form .= '<input type="submit" id="searchsubmit" value="'.attribute_escape(__('Search')).'" />
            </div>
            </form>';
    return $form;
}
add_filter('get_search_form', 'childtheme_search_form');

// Add a custom page leader
// Basically adding the title to a fluid block just after the header
// including a random feature item on the home page
function childtheme_pageleader() { ?>
    <?php global $id, $post, $authordata; ?>
    <div id="leader">
        <div id="leader-container">

<?php if (is_page() && !is_front_page()) { ?>
            <h1 class="entry-title"><?php the_title(); ?></h1>
<?php } elseif (is_404()) { ?>
            <h1 class="entry-title">Not Found</h1>
<?php } elseif (is_page_template('front-page.php') ) {
    /*
    Highlight your most important projects with a series of files (2 to start with) named feature-front-x.php.
    Where x is a number. Then, these files are randomly included on the front page. It’s pretty simple stuff.
    
    The important bit is the mt_rand(1,2). Right now it’s randomly including 1 of 2 files.
    If you had 15 files you’d need to have mt_rand(1,15) in there.
    */
    $rand = mt_rand(1, 2);
    include "includes/feature-front-$rand.php";
} elseif (is_home()) { ?>
            <h1 class="entry-title"><?php bloginfo('name') ?> Blog</h1>
<?php } elseif (is_archive()) { ?>
            <h2 class="entry-title"><?php bloginfo('name') ?> Blog</h2>
<?php } elseif (is_search()) {?>
            <h2 class="entry-title"><?php _e('Search Results for:', 'thematic') ?> <span id="search-terms"><?php echo wp_specialchars(stripslashes($_GET['s']), true); ?></span></h2>            
<?php } elseif (is_single()) { ?>
            <h1 class="entry-title"><?php the_title(); ?></h1>
            <div class="entry-meta">
            	<span class="author vcard"><?php _e('By ', 'thematic') ?><a class="url fn n" href="<?php get_author_link(true, $authordata->ID, $authordata->user_nicename); ?>" title="<?php __('View all posts by ', 'thematic') . the_author(); ?>"><?php the_author() ?></a></span>
            	<span class="meta-sep"> | </span>
            	<span class="entry-date"><abbr class="published" title="<?php get_the_time('Y-m-d\TH:i:sO'); ?>"><?php the_time('F jS, Y') ?></abbr></span>
            </div><!-- .entry-meta -->
<?php } ?>

        </div><!-- #leader-container -->
    </div><!-- #leader -->
<?php }
add_action ('thematic_belowheader','childtheme_pageleader',2);


// Add a custom post header
// A lot of this involves removing the title from where I no longer need it
function childtheme_postheader() {
    global $post; 

    if (is_page() || is_404() || is_single()) {
        // Absence makes the heart grow fonder            
    } else { ?>
		<h2 class="entry-title"><a href="<?php the_permalink() ?>" title="<?php printf(__('Permalink to %s', 'thematic'), wp_specialchars(get_the_title(), 1)) ?>" rel="bookmark"><?php the_title() ?></a></h2>
		<?php if ($post->post_type == 'post') { ?>
		<div class="entry-meta">
          	<span class="author vcard"><?php _e('By ', 'thematic') ?><a class="url fn n" href="<?php get_author_link(true, $authordata->ID, $authordata->user_nicename); ?>" title="<?php __('View all posts by ', 'thematic') . the_author(); ?>"><?php the_author() ?></a></span>
			<span class="meta-sep"> | </span>
			<span class="entry-date"><abbr class="published" title="<?php get_the_time('Y-m-d\TH:i:sO'); ?>"><?php the_time('F jS, Y') ?></abbr></span>
		</div><!-- .entry-meta -->
		<?php } ?>
    <?php }
}
add_filter ('thematic_postheader', 'childtheme_postheader');

?>