<?php

// Filter away the default scripts loaded with Thematic
function childtheme_head_scripts() {
    // Abscence makes the heart grow fonder
}
add_filter('thematic_head_scripts','childtheme_head_scripts');

// Add a link to the footer for credit
function childtheme_theme_link($themelink) {
    return '<a class="child-theme-link" href="http://themeshaper.com/travailler-professional-wordpress-cms-theme/" title="Travailler Theme" rel="designer">Travailler Theme</a>';
}
add_filter('thematic_theme_link', 'childtheme_theme_link');


//Look for variant.css in wp-content/travailler-variant
function travailler_variantcss() {
    // Pre-2.6 compatibility
    if ( !defined('WP_CONTENT_URL') )
        define( 'WP_CONTENT_URL', get_option('siteurl') . '/wp-content');
    if ( !defined('WP_CONTENT_DIR') )
        define( 'WP_CONTENT_DIR', ABSPATH . 'wp-content' );
    
    // Guess the location
    $variantcss_path = WP_CONTENT_DIR.'/travailler-variant/variant.css';
    $variantcss_url = WP_CONTENT_URL.'/travailler-variant/variant.css';

    if (file_exists($variantcss_path)) { ?>   
        <!-- Custom CSS -->
    	<link rel="stylesheet" type="text/css" href="<?php bloginfo('wpurl'); ?>/wp-content//travailler-variant/variant.css" />      	
    	
    <?php } elseif (file_exists($variantcss_url)) { ?>   
        <!-- Custom CSS -->
    	<link rel="stylesheet" type="text/css" href="<?php bloginfo('wpurl'); ?>/wp-content//travailler-variant/variant.css" />
    <?php }  	
} 
add_action('wp_head', 'travailler_variantcss');

//Look for variant.php in wp-content/travailler-variant
function travailler_variantphp() {
    // Pre-2.6 compatibility
    if ( !defined('WP_CONTENT_URL') )
        define( 'WP_CONTENT_URL', get_option('siteurl') . '/wp-content');
    if ( !defined('WP_CONTENT_DIR') )
        define( 'WP_CONTENT_DIR', ABSPATH . 'wp-content' );
    
    // Guess the location
    $variantphp_path = WP_CONTENT_DIR.'/travailler-variant/variant.php';
    $variantphp_url = WP_CONTENT_URL.'/travailler-variant/variant.php';

    if (file_exists($variantphp_path)) {   
        require_once($variantphp_path);
    } elseif (file_exists($variantphp_url)) {   
        require_once($variantphp_url);
    }  	
} 
add_action('wp_head', 'travailler_variantphp');

// Add a changeable header with the Custom Header API

define('HEADER_TEXTCOLOR', '');
define('HEADER_IMAGE', '%s/../travailler/images/header-image.jpg'); // %s is theme dir uri
define('HEADER_IMAGE_WIDTH', 932);
define('HEADER_IMAGE_HEIGHT', 136);
define( 'NO_HEADER_TEXT', true );

function header_style() {
?>
<style type="text/css">
#access {
	background: url(<?php header_image() ?>) no-repeat top center;
}
</style>
<?php
}

function anchor_admin_header_style() {
?>
<style type="text/css">
#headimg {
	height: <?php echo HEADER_IMAGE_HEIGHT; ?>px;
	width: <?php echo HEADER_IMAGE_WIDTH; ?>px;
	max-width:100%;
}
#headimg h1, #headimg #desc {
	display: none;
}
</style>
<?php
}

add_custom_image_header('header_style', 'anchor_admin_header_style');

?>